@extends('layout')
@section('content')

    <!-- domain begin-->
    <div class="domain" id="head_domain" style="padding-top:250px;padding-bottom:120px;">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <div class="row">
                        <form action="{{route('user.exchange')}}" method="post">
                            <div class="col-md-12">
                                <div class="row mt-5">
                                    @csrf
                                    <div class="col-xl-12 col-lg-12">
                                        @include('errors.error')
                                        @if (session('whoops'))
                                            <div class="alert alert-danger alert-dismissible">
                                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                                {!!  __(session('whoops')) !!}
                                            </div>
                                        @endif
                                        @if (session('ok'))
                                            <div class="alert alert-danger alert-dismissible">
                                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                                {!!  __(session('ok')) !!}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-xl-6 col-lg-6">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label><h3><i class="fas fa-arrow-down"></i> @lang('Send Us')</h3> </label>
                                                    <select name="send_method_id" id="from_currency_id" class="form-control sendMethodCurrency form-control-lg prantoChange">
                                                        <option disabled selected>@lang('Select')</option>
                                                        @foreach ($buy_at as $data)
                                                            <option value="{{ $data->id }}" data-min="{{$data->minimum_exchange}}" data-max="{{$data->maximum_exchange}}"> {{ $data->name  }}</option>
                                                        @endforeach
                                                    </select>

                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="text" class="form-control form-control-lg" id="sendMan" name="send_amount" value="100">
                                                </div>
                                                <strong class="text-danger sendLimitAmo">@lang('Exchange Limit') <span class="sendMinAmo"></span> - <span class="sendMaxAmo"></span></strong><br>

                                            </div>


                                        </div>
                                    </div>

                                    <div class="col-xl-6 col-lg-6">

                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label> <h3> <i class="fa fa-arrow-up"></i> @lang('You Receive') </h3> </label>
                                                    <select name="receive_method_id" id="receive_currency_id" class="form-control  form-control-lg receiveMethodCurrency prantoReceiver">
                                                        <option disabled selected>@lang('Select')</option>
                                                        @foreach ($sell_at as $data)
                                                            <option value="{{ $data->id }}" data-reserve="{{$data->reserve_amount}}"> {{ $data->name }} </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="text" class="form-control  form-control-lg" name="receive_amount" id="receiveMan"  value="100" readonly>
                                                </div>
                                                <strong class="text-danger reserveMoney"> @lang('Reserve Amount') : <span class="totalReserveAmo"></span></strong><br>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-12 text-center mt-2">
                                        <button type="submit" class="btn btn-info bnt-lg">@lang('Exchange')</button>
                                    </div>

                                </div>

                            </div>
                        </form>

                        @include('partials.reserve')
                    </div>
                </div>

                @include('partials.todays_rate')
            </div>
        </div>
    </div>
    <!-- domain end -->




    <!-- dedicated plan begin-->
    <div class="dedicated-plan">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8 text-center">
                    <div class="section-title">
                        <h2><span> @lang('Pending Orders')  </span></h2>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('USERNAME') </th>
                                <th scope="col">@lang('SENT') </th>
                                <th scope="col">@lang('RECEIVE') </th>
                                <th scope="col">@lang('AMOUNT') </th>
                                <th scope="col">@lang('STATUS') </th>
                            </tr>
                            </thead>
                            <tbody>

                            @foreach ($pendingOrders as $order)
                                <tr>
                                    <th scope="row">{{ $order->user->username }}</th>
                                    <td>{{ $order->send_method->name }}</td>
                                    <td>{{ $order->receive_method->name }}</td>
                                    <td>{{ $order->send_amount }}  <i class="fas fa-exchange-alt"></i>  {{ $order->receive_amount }}</td>
                                    <td><i class="fa fa-spinner"></i> @lang('Processing') </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>

                    <div class="plan-buttons">
                        <a href="{{route('pending-orders') }}" target="_blank">@lang('View All') </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dedicated plan end -->




    <!-- dedicated plan begin-->
    <div class="dedicated-plan">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8 text-center">
                    <div class="section-title">
                        <h2><span> @lang('Completed Exchanges')  </span></h2>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('USERNAME') </th>
                                <th scope="col">@lang('SENT') </th>
                                <th scope="col">@lang('RECEIVE') </th>
                                <th scope="col">@lang('AMOUNT') </th>
                                <th scope="col">@lang('STATUS') </th>
                            </tr>
                            </thead>
                            <tbody>

                            @foreach ($completedExchanges as $order)
                                <tr>
                                    <th scope="row">{{ $order->user->username }}</th>
                                    <td>{{ $order->send_method->name }}</td>
                                    <td>{{ $order->receive_method->name }}</td>
                                    <td>{{ $order->send_amount }}  <i class="fas fa-exchange-alt"></i>  {{ $order->receive_amount }}</td>
                                    <td><i class="fa fa-check"></i> @lang('Completed') </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>

                    <div class="plan-buttons">
                        <a href="{{route('completed-exchange') }}" target="_blank">@lang('View All') </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dedicated plan end -->



    <!-- testimonial begin-->
    <div class="testimonial" style="background-color:#fff">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8 text-center">
                    <div class="section-title">
                        <h4>{{ __($basic->testimonial_h) }}</h4>
                        <h2>{{ __($basic->testimonial_p) }}</h2>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12 col-lg-12">
                    <div class="testimonial-slider">
                        @foreach ($testimonials as $testimonial)
                            <div class="single-testimonial">
                                <div class="d-flex">
                                    <div class="part-img">
                                        <img src=" {{ asset('assets/images/testimonial/'.$testimonial->image) }} " alt="">
                                    </div>
                                    <div class="part-info">
                                        <h3>{{ $testimonial->name }}</h3>
                                        <h4> {{ $testimonial->designation }}</h4>
                                    </div>
                                </div>
                                <div class="part-text">
                                    <p>“{{$testimonial->details}}”</p>
                                </div>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- testimonial end -->






    <!-- blog begin-->
    <div class="blog-post" style="background-color:#f7fbff;">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8 text-center">
                    <div class="section-title">
                        <h2>@lang('Latest Blog')</h2>
                    </div>
                </div>
            </div>

            <div class="row">
                @foreach ($blogs as $data)
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="single-blog">
                            <div class="part-img">
                                <img src="{{asset('assets/images/post/'.$data->thumb)}}" alt="{{__($data->title)}}">
                            </div>
                            <div class="part-text">
                                <h3><a href="{{route('blog.details',[$data->id, str_slug($data->title)])}}">{{__( str_limit($data->title,60) )}}</a></h3>
                                <p>{{str_limit(strip_tags($data->details),100)}}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- blog end -->

@stop


@section('script')
@stop
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            var senderId = $(".prantoChange").val();
            var receiverId = $(".prantoReceiver").val();
            var sendingAmount = $("#sendMan").val();
            $('.sendLimitAmo').hide();
            $('.reserveMoney').hide();


            $('.prantoChange').on('change', function(){
                var senderId = $(".prantoChange").val();
                var receiverId = $(".prantoReceiver").val();
                var sendingAmount = $("#sendMan").val();

                var sendMaxAmo = $('.sendMethodCurrency option:selected').data('max');
                var sendMinAmo = $('.sendMethodCurrency option:selected').data('min');

                $('.sendMaxAmo').text(sendMaxAmo);
                $('.sendMinAmo').text(sendMinAmo);
                $('.sendLimitAmo').show();




                ajaxReq(senderId,receiverId,sendingAmount);
            });


            $('.prantoReceiver').on('change', function(){
                var senderId = $(".prantoChange").val();
                var receiverId = $(".prantoReceiver").val();
                var sendingAmount = $("#sendMan").val();


               var totalReserveAmo =  $('.receiveMethodCurrency option:selected').data('reserve');

                $('.totalReserveAmo').text(totalReserveAmo);
                $('.reserveMoney').show();


                ajaxReq(senderId,receiverId,sendingAmount);
            });



            $('#sendMan').keyup( function(){

                var senderId = $(".prantoChange").val();
                var receiverId = $(".prantoReceiver").val();
                var sendingAmount = $("#sendMan").val();
                if($(this).val() > 0){
                    ajaxReq(senderId,receiverId,sendingAmount);
                }else{
                    alert('Please Insert Valid Number')
                    $('#sendMan').val(1)

                    var senderId = $(".prantoChange").val();
                    var receiverId = $(".prantoReceiver").val();
                    var sendingAmount = $("#sendMan").val();
                    ajaxReq(senderId,receiverId,sendingAmount);
                }
            });

            function ajaxReq(senderId,receiverId,sendingAmount){
                $.ajax({
                    url: "{{route('get.rate')}}",
                    type: "get",
                    data: {
                        'senderId' : senderId,
                        'receiverId' : receiverId,
                        'sendingAmount' : sendingAmount,

                    } ,
                    success: function (response) {
                        $('#receiveMan').val(response)
                    }
                });
            }



        });
    </script>
@stop